"use client";

import { MasonryPhotoAlbum } from "react-photo-album";

import { Gallery, Item } from "react-photoswipe-gallery";
import "react-photo-album/styles.css";
import "react-photo-album/masonry.css";
import "photoswipe/dist/photoswipe.css";

import Image from "next/image";

import { useGetNamesAlbums } from "@/hooks/useGetNamesAlbums";
import usePhotos from "../galery/photos";
import { useEffect, useState } from "react";

export default function App() {
  const [albumId, setAlbumId] = useState<string | null>(null);

  useEffect(() => {
    const params = new URLSearchParams(window.location.search);
    const slug = params.get("slug");
    setAlbumId(slug);
  }, []);

  const photos = usePhotos({ albumId: albumId || "" });

  const dataAlbumsNames = useGetNamesAlbums();

  const getAlbumNameById = (id: string) => {
    if (dataAlbumsNames.data) {
      const album = dataAlbumsNames.data.find((album) => album.id === id);
      return album ? album.name : "Álbum não encontrado";
    }
  };

  return (
    <div className="relative w-full h-auto bg-cover bg-center">
      <div className="max-w-screen-2xl mx-auto pt-40">
        <div className="flex flex-row items-center mb-9">
          <p className="mr-2 font-normal">Álbum de fotos:</p>
          <p className="mr-2 font-medium">{getAlbumNameById(albumId || "")}</p>
        </div>

        {photos.isLoading && (
          <div className="flex items-center justify-center flex-1 w-full h-full mt-9">
            <p className="text-lg font-medium">Carregando imagens</p>
          </div>
        )}

        {!photos.isLoading && photos.photos.length === 0 && (
          <div className="flex items-center justify-center flex-1 w-full h-full mt-9">
            <p className="text-lg font-medium">Nehuma imagem encontrada</p>
          </div>
        )}

        {!photos.isLoading && photos.photos.length > 0 ? (
          <Gallery>
            <MasonryPhotoAlbum
              photos={photos.photos}
              spacing={5}
              render={{
                photo: ({}, { photo }) => (
                  <Item
                    content={
                      <div className="flex items-center justify-center w-screen h-screen">
                        <Image
                          key={photo.key}
                          src={photo.src}
                          alt={photo.src}
                          width={photo.width}
                          height={photo.height}
                          className="object-contain w-full h-full"
                        />
                      </div>
                    }
                  >
                    {({ ref, open }) => (
                      <div className="flex items-center justify-center">
                        <Image
                          key={photo.key}
                          ref={ref}
                          onClick={open}
                          alt={photo.src}
                          src={photo.src}
                          width={photo.width}
                          height={photo.height}
                          className="object-contain"
                        />
                      </div>
                    )}
                  </Item>
                ),
              }}
            />
          </Gallery>
        ) : (
          <></>
        )}
      </div>
    </div>
  );
}
