import type { Photo } from "react-photo-album";
import { useState, useEffect } from "react";
import { useGetPhotoGallery } from "@/hooks/useGetPhotoGallery";
import { IGetPhotoGallery, IPhotoGallery } from "@/interfaces/IPhotoGallery";

const breakpoints = [1080, 640, 384, 256, 128, 96, 64, 48];

export default function usePhotos({ type, albumId }: IGetPhotoGallery) {
  const [photos, setPhotos] = useState<Photo[]>([]);
  const [isLoading, setIsLoading] = useState(false);

  const { data } = useGetPhotoGallery({ type, albumId });

  useEffect(() => {
    const fetchPhotos = async () => {
      setIsLoading(true);

      if (data && data.length > 0) {
        const photoPromises = data.map((asset: IPhotoGallery) => {
          return {
            key: asset.id,
            src: asset.image,
            width: asset.width,
            height: asset.height,
            srcSet: breakpoints.map((breakpoint) => ({
              src: asset.image,
              width: breakpoint,
              height: Math.round((asset.height / asset.width) * breakpoint),
            })),
            alt: `${asset.image}`,
          };
        });

        const resolvedPhotos = photoPromises;

        setPhotos(resolvedPhotos);
      }
      setIsLoading(false);
    };

    fetchPhotos();
  }, [data]);

  return { photos, isLoading };
}
