import { Button } from "../ui/button";
import { SectionId } from "@/constants/sectionIds";
import { getImagePath } from "@/lib/getImagePath";
import Link from "next/link";

export function CoursesSection() {
  return (
    <div
      id={SectionId.COURSES}
      className="relative w-full h-auto bg-cover bg-center mb-40 sm:mb-0"
    >
      <div className="relative w-full h-full bg-cover bg-center pt-32">
        <h1 className="relative text-3xl font-bold text-black text-center z-10 mb-5">
          Cursos
        </h1>
        <div className="flex max-w-screen-2xl mx-auto w-full items-center gap-0 sm:gap-16 p-0 sm:p-10 flex-col md:flex-row ">
          <div className="w-full md:w-[70%] lg:w-[60%] flex relative justify-end">
            <img
              src={getImagePath("/assets/bg_Courses.svg")}
              alt="Imagem ilustrativa"
              width={300}
              height={300}
              className="hidden sm:block w-full lg:max-w-[100%] max-1259:w-[80%] h-auto object-cover"
            />
            <div
              className={`relative sm:absolute md:absolute mb-10 w-full  flex flex-col items-center lg:w-[100%] max-1259:w-[78%] pt-10 lg:pt-24 bg-[url('${getImagePath(
                "/assets/bg_Courses.svg"
              )}')] sm:bg-none bg-cover bg-center`}
            >
              <p className="text-white font-normal mb-9 pl-14 pr-14 text-justify ">
                O Instituto de Ciências Exatas e Tecnologia da Universidade
                Federal do Amazonas (ICET/UFAM), localizado no município de
                Itacoatiara - Amazonas, oferta 10 cursos de graduação, sendo 2
                da área da Computação: Engenharia de Software e Sistemas de
                Informação.
                <br />
                <br />O Curso de Bacharelado em Engenharia de Software visa
                desenvolver um profissional comprometido com a aplicação das
                soluções tanto na indústria de desenvolvimento de software
                quanto nas organizações públicas e privadas.
                <br />
                <br />O Curso de Bacharelado em Sistemas de Informação visa
                desenvolver um profissional comprometido com a aplicação das
                soluções nas organizações administrativas no que concerne aos
                problemas culturais, éticos e técnico-científicos, situados no
                estado da arte da ciência e tecnologia em computação.
              </p>
              <Link
                href="/courses"
                passHref
                className="w-full sm:w-auto flex justify-center"
              >
                <Button variant={"secondary"}>Saiba mais</Button>
              </Link>
            </div>
          </div>

          <div className="w-[100%] md:w-[30%] lg:w-[40%] flex  items-start  md:justify-end flex-row md:flex-col gap-14 justify-center ">
            <div className="flex items-center justify-center flex-col">
              <img
                src={getImagePath("/assets/Logo-ES.png")}
                alt="Imagem ilustrativa"
                width={140}
                height={120}
                className="w-[50%] sm:w-[50%] md:w-[50%] h-auto object-cover"
              />
              <p className="text-xl font-medium text-black text-center uppercase mt-2">
                Engenharia de <br /> Software
              </p>
            </div>

            <div className="flex items-center justify-center flex-col">
              <img
                src={getImagePath("/assets/Logo-SI.png")}
                alt="Imagem ilustrativa"
                width={130}
                height={120}
                className="w-[50%] sm:w-[50%] md:w-[50%] h-auto object-cover"
              />
              <p className="text-xl font-medium text-black text-center uppercase mt-2">
                Sistemas de <br /> Informação
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}
