import { SectionId } from "@/constants/sectionIds";
import { getImagePath } from "@/lib/getImagePath";
import Image from "next/image";
import Link from "next/link";

export function Footer() {
  return (
    <footer
      id={SectionId.CONTACT}
      className="w-full flex flex-col mt-auto items-center p-4"
    >
      <h1 className="text-3xl font-bold text-black mb-10">Contato</h1>
      <div className="flex items-center flex-col md:flex-row gap-4">
        <div className="w-full md:w-1/2 flex justify-center md:justify-end ">
          <img
            src={getImagePath("/assets/logar_preto.png")}
            alt={"Logar"}
            width={359}
            height={195}
          />
        </div>

        <div className="h-44 w-[1px] bg-black ml-14 mr-14 hidden md:flex" />

        <div className="w-full md:w-1/2 flex items-center flex-col">
          <ul className="flex flex-col gap-4">
            <li>
              <Link
                className={"flex items-start"}
                href="https://maps.app.goo.gl/5ZM2Y461PaCeRKuh6"
                target="_blank"
              >
                <Image
                  src={getImagePath("/assets/location.svg")}
                  className="mr-2 mt-1"
                  alt={"Localização"}
                  width={28}
                  height={36}
                />
                Rua Nossa Senhora do Rosário, 3863 - Tiradentes - CEP:
                69.103-128 - Itacoatiara - Amazonas - Brasil
              </Link>
            </li>

            <li>
              <Link className={"flex items-start"} href="/" target="_blank">
                <Image
                  src={getImagePath("/assets/facebook.svg")}
                  className="mr-2 mt-1"
                  alt={"Localização"}
                  width={28}
                  height={36}
                />
                https://www.facebook.com/
              </Link>
            </li>
          </ul>
        </div>
      </div>
    </footer>
  );
}
