import { Button } from "../ui/button";
import { SectionId } from "@/constants/sectionIds";
import { getImagePath } from "@/lib/getImagePath";
import Link from "next/link";

export function GalleySection() {
  return (
    <div
      id={SectionId.GALLERY}
      className="relative w-full h-auto bg-cover bg-center mb-96 sm:mb-0"
    >
      <div className="relative w-full h-full bg-cover bg-center pt-32">
        <h1 className="relative text-3xl font-bold text-black text-center z-10">
          Galeria
        </h1>
        <div className="flex max-w-screen-2xl mx-auto w-full items-center justify-between gap-4 p-0 sm:p-10 flex-col md:flex-row ">
          <div className=" w-[100%] md:w-[30%] lg:w-[40%] flex flex-row items-center justify-center md:justify-end">
            <img
              src={getImagePath("/assets/sectionGallery.png")}
              alt="Imagem ilustrativa"
              width={300}
              height={300}
              className="w-[100%]: lg:w-[60%] h-auto object-cover"
            />
          </div>

          <div className="w-full md:w-[70%] lg:w-[60%] flex relative ">
            <img
              src={getImagePath("/assets/bgGallery.svg")}
              alt="Imagem ilustrativa"
              width={300}
              height={300}
              className="hidden sm:block w-full sm:w-[650px] h-auto object-cover"
            />
            <div
              className={`absolute mb-10 w-full sm:w-[80%] pl-14 flex flex-col items-center lg:w-[70%] pt-10 lg:pt-24 bg-[url('${getImagePath(
                "/assets/bgGallery.svg"
              )}')] sm:bg-none bg-cover bg-center`}
            >
              <p className="text-white font-normal mb-9 pr-14 sm:pr-0  ">
                Nossa galeria de fotos proporciona uma visão envolvente e
                cativante do Laboratório de Computação e de seus respectivos
                projetos. Por meio dessa coleção, você terá acesso a uma seleção
                de imagens que ilustram nosso trabalho. Esperamos que o conteúdo
                apresentado seja apreciado. Convidamos você a explorar
                visualmente as experiências e momentos inspiradores que
                compartilhamos.
              </p>
              <Link
                href="/galery"
                passHref
                className="w-full sm:w-auto -ml-14 flex justify-center"
              >
                <Button variant={"secondary"}>Saiba mais</Button>
              </Link>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}
