"use client";

import {
  Table,
  TableBody,
  TableCaption,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from "@/components/ui/table";
import {
  Select,
  SelectContent,
  SelectItem,
  SelectTrigger,
  SelectValue,
} from "@/components/ui/select";
import { useRouter } from "next/navigation";

import { useState } from "react";
import { IPageParams } from "@/app/projects/[slug]/page";
import { useGetProjects } from "@/hooks/useGetProjects";

const dataNamesProjects = [
  { id: "ensino", name: "Ensino" },
  { id: "pesquisa", name: "Pesquisa" },
  { id: "extensao", name: "Extensão" },
];

export function ProjectsHome({ params: { slug } }: IPageParams) {
  const router = useRouter();

  const [filterTypeProject, setFilterTypeProject] = useState<"Todos" | string>(
    slug
  );
  const queryProjects = useGetProjects({ type: filterTypeProject });

  const [typeProjectSelect, setTypeProjectSelect] = useState<string>(
    getIdNameById(slug) as string
  );

  if (queryProjects.isLoading) {
    return (
      <div className="max-w-screen-2xl mx-auto pt-40">
        <div className="flex flex-row justify-center items-center mb-9">
          <p>Carregando...</p>
        </div>
      </div>
    );
  }

  function getIdByName(projectName: string) {
    const project = dataNamesProjects.find(
      (item) => item.name.toLowerCase() === projectName.toLowerCase()
    );
    return project ? project.id : null;
  }

  function getIdNameById(id: string) {
    const project = dataNamesProjects.find(
      (item) => item.id.toLowerCase() === id.toLowerCase()
    );
    return project ? project.name : null;
  }

  function findIdTypeProjects(id: string) {
    const project = dataNamesProjects.find(
      (item) => item.id.toLowerCase() === id.toLowerCase()
    );
    return project ? project.id : null;
  }

  const updateURL = (newSlug: string) => {
    const idSlug = getIdByName(newSlug) as string;
    router.replace(`/projects/${idSlug}`);
  };

  function onFilterTypeProject(typeSelected: string) {
    updateURL(typeSelected);
    setTypeProjectSelect(typeSelected);
    const idTypeFilter = getIdByName(typeSelected) as string;
    setFilterTypeProject(idTypeFilter);
  }

  return (
    <div className="max-w-screen-2xl mx-auto pt-40">
      <div className="flex flex-row justify-between items-center mb-9">
        <div className="flex flex-row justify-between items-center">
          <p className="mr-2 font-medium">Selecione o tipo de projeto:</p>
          <Select
            onValueChange={onFilterTypeProject}
            defaultValue={
              findIdTypeProjects(slug) !== null ? typeProjectSelect : undefined
            }
          >
            <SelectTrigger className="w-auto">
              <SelectValue placeholder="Selecione" />
            </SelectTrigger>
            <SelectContent>
              {dataNamesProjects.map((item) => (
                <SelectItem key={item.id} value={item.name}>
                  {item.name}
                </SelectItem>
              ))}
            </SelectContent>
          </Select>
        </div>
      </div>

      {findIdTypeProjects(slug) !== null && (
        <div className="flex flex-row justify-center items-center mb-9">
          <p>
            Veja abaixo algumas atividades de
            <span className="font-bold"> {typeProjectSelect} </span>realizadas
            por colaboradores do LOGAR
          </p>
        </div>
      )}

      <Table className="border border-gray-300">
        <TableHeader>
          <TableRow className="border border-gray-300">
            <TableHead className="text-center text-black font-semibold border border-gray-300">
              Ano
            </TableHead>
            <TableHead className="text-center text-black font-semibold border border-gray-300">
              Título
            </TableHead>
            <TableHead className="text-center text-black font-semibold border border-gray-300">
              Situação
            </TableHead>
            <TableHead className="text-center text-black font-semibold border border-gray-300">
              Integrantes
            </TableHead>
            <TableHead className="text-center text-black font-semibold border border-gray-300">
              Financiador
            </TableHead>
          </TableRow>
        </TableHeader>
        {queryProjects.data !== undefined && queryProjects.data?.length > 0 ? (
          queryProjects.data?.map((project) => (
            <TableBody key={project.id}>
              <TableRow className="border border-gray-300">
                <TableCell className="text-center border border-gray-300">
                  {project.year}
                </TableCell>
                <TableCell className="text-center border border-gray-300">
                  {project.title}
                </TableCell>
                <TableCell className="text-center border border-gray-300">
                  {project.situation}
                </TableCell>
                <TableCell className="text-center border border-gray-300">
                  {project.members}
                </TableCell>
                <TableCell className="text-center border border-gray-300">
                  {project.financier}
                </TableCell>
              </TableRow>
            </TableBody>
          ))
        ) : (
          <TableCaption>Sem dados a serem exibidos</TableCaption>
        )}
      </Table>
    </div>
  );
}
