"use client";

import { SectionId } from "@/constants/sectionIds";
import { useGetTeachers } from "@/hooks/useGetTeachers";
import { DialogInfoTeacher } from "./dialogInfoTeacher";

export function ResponsibleTeachersSection() {
  const query = useGetTeachers();

  return (
    <div
      id={SectionId.TEACHERS}
      className="relative w-full h-auto bg-cover bg-center mb-96 sm:mb-20"
    >
      <div className="relative w-full h-full bg-cover bg-center pt-32">
        <h1 className="relative text-3xl font-bold text-black text-center z-10">
          Docentes Responsáveis
        </h1>
        <div className="flex flex-wrap justify-center items-center mt-8 gap-6">
          {query.data !== undefined && query.data.length > 0
            ? query.data.map((teacher, index) => (
                <DialogInfoTeacher
                  key={index}
                  data={teacher}
                  typeScreen="home"
                />
              ))
            : null}
        </div>
      </div>
    </div>
  );
}
