import { useRouter } from "next/router";

/**
 * Hook que retorna uma função para montar o caminho completo de uma imagem pública,
 * levando em conta o basePath automaticamente.
 */
export function useImagePath() {
  const { basePath } = useRouter();

  return (path: string) => {
    const normalizedPath = path.startsWith("/") ? path : `/${path}`;
    return `${basePath}${normalizedPath}`;
  };
}
