import { db } from "@/config/firebaseConfig";
import {
  collection,
  DocumentData,
  getDocs,
  query,
  QuerySnapshot,
  where,
} from "firebase/firestore";
import { IGetPhotoGallery, IPhotoGallery } from "@/interfaces/IPhotoGallery";

export async function getPhotoGalleryService({
  type,
  albumId,
}: IGetPhotoGallery) {
  let querySnapshot: QuerySnapshot<DocumentData> | null = null;

  if (albumId) {
    const projectsRef = collection(db, "gallery_screen");
    const q = query(projectsRef, where("albumId", "==", albumId));
    querySnapshot = await getDocs(q);
  } else if (type === "Todos" || type == undefined) {
    querySnapshot = await getDocs(query(collection(db, "gallery_screen")));
  }

  if (!querySnapshot) return [];

  const projects: IPhotoGallery[] = [];
  querySnapshot.forEach((doc) => {
    const publication = {
      ...doc.data(),
      id: doc.id,
    } as IPhotoGallery;
    projects.push(publication);
  });

  return projects;
}
