import { IGetPublication, IPublication } from "@/interfaces/IPublications";
import { db } from "@/config/firebaseConfig";
import { collection, getDocs, query, where, orderBy } from "firebase/firestore";

export async function getTPublicationsService({ teacherId }: IGetPublication) {
  let querySnapshot;

  if (teacherId === "Todos" || teacherId == undefined) {
    querySnapshot = await getDocs(
      query(
        collection(db, "publications"),
        orderBy("yearOfPublication", "desc")
      )
    );
  } else {
    const publicationsRef = collection(db, "publications");
    const q = query(publicationsRef, where("teacherId", "==", teacherId));
    querySnapshot = await getDocs(q);
  }

  const publications: IPublication[] = [];
  querySnapshot.forEach((doc) => {
    const publication = {
      ...doc.data(),
      id: doc.id,
    } as IPublication;
    publications.push(publication);
  });

  publications.sort((a, b) => {
    const yearA = a.yearOfPublication ? a.yearOfPublication : 0;
    const yearB = b.yearOfPublication ? b.yearOfPublication : 0;
    return yearB - yearA;
  });

  return publications;
}
