import { ITeacher } from "@/interfaces/ITeacher";
import { db } from "@/config/firebaseConfig";
import { collection, getDocs } from "firebase/firestore";
import { getFirstAndLastName } from "@/app/functions/getFirstAndLastName";
import { getTeacherImageByName } from "@/app/functions/getTeacherImageByName";

export async function getTeachersService() {
  const querySnapshot = await getDocs(collection(db, "teacher"));
  const teachers: ITeacher[] = [];
  querySnapshot.forEach((doc) => {
    const dataValue = {
      ...doc.data(),
      id: doc.id,
    } as ITeacher;

    const { firstName, lastName } = getFirstAndLastName(dataValue.name);
    const avatar = getTeacherImageByName(`${firstName} ${lastName}`);

    const dataTeacher = {
      ...dataValue,
      firstAndLastName: `${firstName} ${lastName}`,
      avatar: avatar,
    } as ITeacher;

    teachers.push(dataTeacher);
  });

  teachers.sort((a, b) => a.name.localeCompare(b.name));

  return teachers;
}
